-- events for main menu

T_TIME_BONUS = Localize ("Visions found: %d");
T_TIME_BONUSTIME = Localize ("You gained %d seconds for all the next seven levels!");
T_TIME_BONUSTIME_LAST = Localize ("You approach the altar calm and confident.");
T_RATING_PERFECT = Localize ("Perfect!");
T_RATING_OUT_OF_TIME = Localize ("Out of time");

itemwidth = 0;
totalwidth = 0;
num = 0;
total = 7;
totallit = 0;
interval = 0;

function OnLoad ()
	SetProperty ("/:enter_trans_duration", 0.50);
	SetProperty ("/:leave_trans_duration", 0.4);
	NX_GetBitmap("hidden/visions_slot.png");
	NX_GetBitmap("hidden/visions_light.png");
	
end;


function OnEnter ()
	StopMusic (2);
	NX_PlaySound ("music/trophy.ogg");
	interval = 0;
	totallit = 0;
	num = Azkend_GetCurrentVisionNum ();
	itemwidth = GetProperty("widthitem:width");
	totalwidth = total * num;
	
	if (num == total) then
		SetProperty ("rating:label.text", T_RATING_PERFECT);
	else
		SetProperty ("rating:label.text", T_RATING_OUT_OF_TIME);
	end;
	
	
	
	if (GetGameValue ("level_number") > 65) then
		SetProperty ("vision_time:label.text", T_TIME_BONUSTIME_LAST);
	else
		SetProperty ("vision_time:label.text", string.format (T_TIME_BONUSTIME, 0))
	end;

		SetProperty ("vision_prize:label.text", string.format (T_TIME_BONUS, 0));

  	if (Azkend_AutoplayerActive ()) then
		OnClick ("Ok");
	end;
	
	timer = 0;
end;

function OnLeave ()
    
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "Ok") then	
		--PopScreen ();
		level_number = GetGameValue ("level_number");
		the_last_level = GetGameValue ("number_of_levels");
	  
		if (level_number >= the_last_level) then
			SwitchScreen ("GameCompleted");
		else
			SwitchScreen ("HiddenObjectCompleted");
		end;
	end;
	
end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();
	
	timer = timer + 2*tdelta;

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	--SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("frames:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));

  	SetProperty ("pic:scale", 0.2 + 0.8 * trans);
  	SetProperty ("pic:angle", (1-trans) * 6);
  	SetProperty ("pic:position_offset.y", -200 * (1-trans));
  
	if(interval > 0.5 and totallit < num) then
		SpawnFX ("fxs/hidden-marker-added.lua", GetProperty("dummy:static_position.x")+(itemwidth*(totallit+1))+(itemwidth/2), GetProperty("dummy:static_position.y")+(itemwidth/2), 0, 0);
		totallit = totallit + 1;
		SetProperty ("vision_prize:label.text", string.format (T_TIME_BONUS, totallit));
		
	
	if (GetGameValue ("level_number") > 65) then
		SetProperty ("vision_time:label.text", T_TIME_BONUSTIME_LAST);
	else
		SetProperty ("vision_time:label.text", string.format (T_TIME_BONUSTIME, totallit));
	end;
		
		interval = 0;
	else
		interval = interval + 2*tdelta;
	end;
	
end;

function OnDraw ()

	local x = GetProperty ("clock:static_position.x");
	local y = GetProperty ("clock:static_position.y");
	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());

	local num = Azkend_GetCurrentVisionNum ();

	local t = 2*math.pi * math.min (2*timer, num)/12;
	
	Azkend_DrawSmallClock (x, y, t, 1, trans);

	for i = 1, total, 1 do
		NX_SetAlpha(1.0);
		NX_SetColor(1.0,1.0,1.0);
		NX_DrawBitmap("hidden/visions_slot.png", GetProperty("dummy:static_position.x")+(itemwidth*i), GetProperty("dummy:static_position.y"));
	end;
	
	for i = 1, totallit, 1 do
		NX_SetAlpha(1.0);
		NX_SetColor(1.0,1.0,1.0);
		NX_DrawBitmap("hidden/visions_light.png", GetProperty("dummy:static_position.x")+(itemwidth*i), GetProperty("dummy:static_position.y"));
	end;
end;
